/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup_ui.email;

import java.util.ResourceBundle;
import systems.dmx.signup.EmailTextProducer;

public class SignUpUiEmailTextProducer
implements EmailTextProducer {
    private ResourceBundle rb;
    private String webAppTitle;
    private String hostUrl;

    public SignUpUiEmailTextProducer(String hostUrl, String webAppTitle, ResourceBundle rb) {
        this.hostUrl = hostUrl;
        this.webAppTitle = webAppTitle;
        this.rb = rb;
    }

    public boolean isHtml() {
        return true;
    }

    String getPasswordResetUrl(String key) {
        return this.hostUrl + "/sign-up-ui/password-reset/" + key;
    }

    private String getConfirmationLink(String key) {
        String href = this.hostUrl + "sign-up-ui/confirm/" + key;
        return "<a href=\"" + href + "\">" + this.rb.getString("mail_confirmation_link_label") + "</a>";
    }

    public String getConfirmationActiveMailSubject() {
        return this.rb.getString("mail_confirmation_subject") + " - " + this.webAppTitle;
    }

    public String getConfirmationActiveMailMessage(String username, String key) {
        String linkHref = this.getConfirmationLink(key);
        return this.rb.getString("mail_hello") + " " + username + ",<br><br>" + this.rb.getString("mail_confirmation_active_body") + "<br><br>" + linkHref + "<br><br>" + this.rb.getString("mail_ciao");
    }

    public String getConfirmationProceedMailSubject() {
        return this.rb.getString("mail_confirmation_subject") + " - " + this.webAppTitle;
    }

    public String getUserConfirmationProceedMailMessage(String username, String key) {
        String linkHref = this.getConfirmationLink(key);
        return this.rb.getString("mail_hello") + " " + username + ",<br><br>" + this.rb.getString("mail_confirmation_proceed_1") + "<br>" + linkHref + "<br><br>" + this.rb.getString("mail_confirmation_proceed_2") + "<br><br>" + this.rb.getString("mail_ciao");
    }

    public String getApiUsageRevokedMailSubject() {
        return "API Usage Revoked";
    }

    public String getApiUsageRevokedMailText(String username) {
        return "<br>Hi admin,<br><br>" + username + " just revoked his/her acceptance to your Terms of Service for API-Usage.<br><br>Just wanted to let you know.<br>Cheers!";
    }

    public String getAccountActiveEmailSubject() {
        return "Your account on " + this.webAppTitle + " is now active";
    }

    public String getAccountActiveEmailMessage(String username) {
        return this.rb.getString("mail_hello") + " " + username + ",<br><br>your account on <a href=\"" + this.hostUrl + "\">" + this.webAppTitle + "</a> is now active.<br><br>" + this.rb.getString("mail_ciao");
    }

    public String getApiUsageRequestedSubject() {
        return "API Usage Requested";
    }

    public String getApiUsageRequestedMessage(String username) {
        return "<br>Hi admin,<br><br>" + username + " accepted the Terms of Service for API Usage.<br><br>Just wanted to let you know.<br>Cheers!";
    }

    public String getPasswordResetMailSubject() {
        return this.rb.getString("mail_pw_reset_title") + " " + this.webAppTitle;
    }

    public String getPasswordResetMailMessage(String addressee, String key) {
        String href = this.getPasswordResetUrl(key);
        return this.rb.getString("mail_hello") + "!<br><br>" + this.rb.getString("mail_pw_reset_body") + "<br><a href=\"" + href + "\">" + href + "</a><br><br>" + this.rb.getString("mail_cheers") + "<br>" + this.rb.getString("mail_signature");
    }

    public String getAccountCreationSystemEmailSubject() {
        return "Account registration on " + this.webAppTitle;
    }

    public String getAccountCreationSystemEmailMessage(String username, String mailbox) {
        return "<br>A user has registered.<br><br>Username: " + username + "<br>Email: " + mailbox;
    }
}

