/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.sendmail;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.sendmail.Configuration;
import systems.dmx.sendmail.JavaMail;
import systems.dmx.sendmail.SendMailFromToUseCase;
import systems.dmx.sendmail.SendmailService;
import systems.dmx.sendmail.util.SendgridWebApiV3;

public class SendmailPlugin
extends PluginActivator
implements SendmailService {
    static final Logger logger = Logger.getLogger(SendmailPlugin.class.getName());
    Configuration configuration;
    SendMailFromToUseCase sendMailFromToUseCase;

    public void init() {
        try {
            this.configuration = Configuration.loadFromPluginProperties();
            this.sendMailFromToUseCase = new SendMailFromToUseCase(this.configuration.getSendmailType(), new JavaMail(this.configuration), new SendgridWebApiV3(this.configuration.getSendgridApiKey()));
            this.logAndTestConfiguration();
        }
        catch (IOException ex) {
            Logger.getLogger(SendmailPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void logAndTestConfiguration() throws IOException {
        logger.info("\n  dmx.sendmail.system_from_name: " + this.configuration.getSystemFromName() + "\n  dmx.sendmail.system_from_mailbox: " + this.configuration.getSystemFromEmailAddress() + "\n  dmx.sendmail.system_admin_mailbox: " + this.configuration.getSystemAdminEmailAddress() + "\n  dmx.sendmail.type: " + this.configuration.getSendmailType());
        logger.info("\n  dmx.sendmail.greeting_enabled: " + this.configuration.isGreetingEnabled());
        logger.info("\n  dmx.sendmail.greeting_subject: " + (this.configuration.getGreetingSubject().equals("Sendmail Plugin Activated") ? "<built-in subject>" : "<custom subject>"));
        logger.info("\n  dmx.sendmail.greeting_message: " + (this.configuration.getGreetingMessage().equals("Hello dear, this is your new email sending service.\n\nWe hope you can enjoy the comforts!") ? "<built-in message>" : "<custom message>"));
        logger.info("\n  dmx.sendmail.greeting_html_message: " + (this.configuration.getGreetingHtmlMessage() == null ? "<not explicitly set>" : "<custom message>"));
        if (this.configuration.getSendmailType().equals("smtp")) {
            logger.info("\n  dmx.sendmail.smtp_host: " + this.configuration.getSmtpHost() + "\n  dmx.sendmail.smtp_username: " + this.configuration.getSmtpUsername() + "\n  dmx.sendmail.smtp_password: PASSWORD HIDDEN FOR LOG\n  dmx.sendmail.smtp_port: " + this.configuration.getSmtpPort() + "\n  dmx.sendmail.smtp_security: " + this.configuration.getSmtpSecurity() + "\n  dmx.sendmail.smtp_debug: " + this.configuration.isSmtpDebugEnabled());
        } else if (this.configuration.getSendmailType().equals("sendgrid")) {
            if (this.configuration.getSendgridApiKey().isEmpty()) {
                logger.severe("Configuration Error: DMX Sendmail is configured to send mails via Sendgrid API but has no\"dmx.sendmail.sendgrid_api_key\" value set");
            } else {
                logger.info("dmx.sendmail.sendgrid_api_key: API KEY HIDDEN FOR LOG");
            }
        } else {
            logger.severe("Configuration Error: DMX Sendmail has an invalid \"dmx.sendmail.type\" value set");
        }
        logger.info("Sending test mail per " + this.configuration.getSendmailType() + " on init to \"" + this.configuration.getSystemAdminEmailAddress() + "\"");
        if (this.configuration.isGreetingEnabled()) {
            this.doEmailSystemMailbox(this.configuration.getGreetingSubject(), this.configuration.getGreetingMessage(), this.configuration.getGreetingHtmlMessage());
        }
    }

    @Override
    public void doEmailUser(String username, String subject, String message, String htmlMessage) {
        String userMailbox = this.dmx.getPrivilegedAccess().getEmailAddress(username);
        if (userMailbox != null) {
            this.sendMailTo(userMailbox, subject, message, htmlMessage);
        } else {
            logger.severe("Sending email notification to user not possible, \"" + username + "\" has not signed-up with an Email Address");
        }
    }

    @Override
    public void doEmailUser(String fromUsername, String toUsername, String subject, String message, String htmlMessage) {
        String senderMailbox = this.dmx.getPrivilegedAccess().getEmailAddress(fromUsername);
        String recipientMailbox = this.dmx.getPrivilegedAccess().getEmailAddress(toUsername);
        if (recipientMailbox != null && senderMailbox != null) {
            this.sendMailFromTo(senderMailbox, fromUsername, recipientMailbox, toUsername, subject, message, htmlMessage);
        } else {
            logger.severe("Sending email notification to user not possible. Either \"" + toUsername + "\" or \"" + fromUsername + "\" has not signed-up with an Email Address");
        }
    }

    @Override
    public void doEmailRecipientAs(String from, String fromName, String subject, String message, String htmlMessage, String recipientMail) {
        this.sendMailFromTo(from, fromName, recipientMail, null, subject, message, htmlMessage);
    }

    @Override
    public void doEmailRecipient(String subject, String message, String htmlMessage, String recipientMail) {
        this.sendMailTo(recipientMail, subject, message, htmlMessage);
    }

    @Override
    public void doEmailSystemMailbox(String subject, String message, String htmlMessage) {
        this.sendMailTo(this.configuration.getSystemAdminEmailAddress(), subject, message, htmlMessage);
    }

    private void sendMailTo(String recipient, String subject, String textMessage, String htmlMessage) {
        this.sendMailFromTo(this.configuration.getSystemFromEmailAddress(), this.configuration.getSystemFromName(), recipient, null, subject, textMessage, htmlMessage);
    }

    private void sendMailFromTo(String sender, String senderName, String recipientMailbox, String recipientName, String subject, String textMessage, String htmlMessage) {
        this.sendMailFromToUseCase.invoke(sender, senderName, recipientMailbox, recipientName, subject, textMessage, htmlMessage);
    }
}

