/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.ldap;

import java.util.Locale;
import java.util.logging.Logger;
import systems.dmx.accountmanagement.AccountManager;
import systems.dmx.accountmanagement.CheckCredentialsResult;
import systems.dmx.core.service.accesscontrol.Credentials;
import systems.dmx.ldap.Configuration;
import systems.dmx.ldap.repository.JndiRepository;

class LDAPAccountManager
implements AccountManager {
    private static final Logger logger = Logger.getLogger(LDAPAccountManager.class.getName());
    private final Configuration configuration;
    private final JndiRepository jndiRepository;

    LDAPAccountManager(Configuration configuration, JndiRepository jndiRepository) {
        this.configuration = configuration;
        this.jndiRepository = jndiRepository;
    }

    public String name() {
        return "LDAP";
    }

    public CheckCredentialsResult checkCredentials(Credentials cred) {
        String username = this.sanitise(cred.username);
        if (this.jndiRepository.checkCredentials(username, cred.password)) {
            logger.info(() -> String.format("LDAP credential check successful for user %s", username));
            return CheckCredentialsResult.lookupOrCreationRequired();
        }
        logger.severe(String.format("LDAP credential check failed for user %s", username));
        return CheckCredentialsResult.failed();
    }

    public void createAccount(Credentials credentials) {
        if (!this.configuration.userCreationEnabled) {
            throw new IllegalStateException("User creation is disabled in LDAP plugin configuration!");
        }
        this.jndiRepository.createUser(this.sanitise(credentials.username), credentials.password, new JndiRepository.CompletableAction(){});
    }

    public void changePassword(Credentials currentCredentials, Credentials newCredentials) {
        if (!this.configuration.userCreationEnabled) {
            throw new IllegalStateException("Cannot change password because user creation is disabled in LDAP plugin configuration!");
        }
        String username = this.sanitise(newCredentials.username);
        if (!this.jndiRepository.changePassword(username, newCredentials.password)) {
            throw new IllegalStateException("Password change failed");
        }
        logger.info(() -> String.format("Successfully changed password for %s", username));
    }

    public void onUsernameDeleted(String username) {
        if (this.configuration.userDeletionEnabled) {
            logger.info(() -> String.format("Deleting user from LDAP %s", username));
            this.jndiRepository.deleteUser(username);
        }
    }

    private String sanitise(String sourceUsername) {
        return sourceUsername.toLowerCase(Locale.ROOT);
    }
}

