/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.dita;

import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.service.CoreService;
import systems.dmx.topicmaps.TopicmapsService;

public class TopicmapNavigation {
    private long topicmapId;
    private TopicmapsService tmService;
    private CoreService dmx;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public TopicmapNavigation(long topicmapId, TopicmapsService tmService, CoreService dmx) {
        this.topicmapId = topicmapId;
        this.tmService = tmService;
        this.dmx = dmx;
    }

    public RelatedTopic getRelatedTopic(long topicId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        List topics = this.dmx.getTopic(topicId).getRelatedTopics(assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri).stream().filter(this::isInTopicmap).collect(Collectors.toList());
        switch (topics.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (RelatedTopic)topics.get(0);
            }
        }
        throw new RuntimeException("Ambiguity");
    }

    private boolean isInTopicmap(RelatedTopic topic) {
        return this.tmService.getAssocMapcontext(this.topicmapId, topic.getRelatingAssoc().getId()) != null;
    }
}

