/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.dita;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import systems.dmx.core.ChildTopics;
import systems.dmx.core.Topic;

class DITAExporter {
    public static final String DOCTYPE_TOPIC = "<!DOCTYPE topic PUBLIC \"-//OASIS//DTD DITA Topic//EN\" \"topic.dtd\">";
    public static final String DOCTYPE_MAP = "<!DOCTYPE map PUBLIC \"-//OASIS//DTD DITA Map//EN\" \"map.dtd\">";
    private static final XMLOutputFactory xmlFactory = XMLOutputFactory.newFactory();
    private File outputDir;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private static final List TAG_FILTER = Arrays.asList("html", "head", "body", "span", "br");

    DITAExporter(File outputDir) {
        this.outputDir = outputDir;
    }

    void export(Topic topicmap, List<Topic> topics) {
        topics.stream().forEach(this::exportTopic);
        this.exportTopicmap(topicmap, topics);
    }

    private void exportTopic(Topic topic) {
        try (BufferedWriter bf = this.newFileWriter(topic.getId() + ".xml");){
            XMLStreamWriter writer = xmlFactory.createXMLStreamWriter(bf);
            ChildTopics ct = topic.getChildTopics();
            writer.writeStartDocument();
            writer.writeDTD(DOCTYPE_TOPIC);
            writer.writeStartElement("topic");
            writer.writeAttribute("id", "topic-" + topic.getId());
            writer.writeStartElement("title");
            writer.writeCharacters(ct.getString("dmx.dita.title"));
            writer.writeEndElement();
            writer.writeStartElement("body");
            this.parseHTML(ct.getString("dmx.dita.body"), writer);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
        }
        catch (Exception e) {
            throw new RuntimeException("Writing XML file for topic " + topic.getId() + " failed", e);
        }
    }

    private void exportTopicmap(Topic topicmap, List<Topic> topics) {
        try (BufferedWriter bf = this.newFileWriter(topicmap.getId() + ".xml");){
            XMLStreamWriter writer = xmlFactory.createXMLStreamWriter(bf);
            writer.writeStartDocument();
            writer.writeDTD(DOCTYPE_MAP);
            writer.writeStartElement("map");
            writer.writeStartElement("title");
            writer.writeCharacters(topicmap.getSimpleValue().toString());
            writer.writeEndElement();
            topics.stream().forEach(topic -> this.writeTopicref((Topic)topic, writer));
            writer.writeEndElement();
            writer.writeEndDocument();
        }
        catch (Exception e) {
            throw new RuntimeException("Writing XML file for topicmap " + topicmap.getId() + " failed", e);
        }
    }

    private void writeTopicref(Topic topic, XMLStreamWriter writer) {
        try {
            writer.writeStartElement("topicref");
            writer.writeAttribute("href", topic.getId() + ".xml");
            writer.writeAttribute("type", "topic");
            writer.writeEndElement();
        }
        catch (Exception e) {
            throw new RuntimeException("Writing <topicref> element for topic " + topic.getId() + " failed", e);
        }
    }

    private BufferedWriter newFileWriter(String filename) throws IOException {
        return new BufferedWriter(new FileWriter(new File(this.outputDir, filename)));
    }

    private void parseHTML(String html, XMLStreamWriter writer) {
        try {
            new ParserDelegator().parse(new StringReader(html), new XMLWriterCallback(writer), false);
        }
        catch (Exception e) {
            throw new RuntimeException("HTML parsing failed", e);
        }
    }

    private class XMLWriterCallback
    extends HTMLEditorKit.ParserCallback {
        private XMLStreamWriter writer;

        private XMLWriterCallback(XMLStreamWriter writer) {
            this.writer = writer;
        }

        @Override
        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            try {
                if (this.filter(t)) {
                    this.writer.writeStartElement(t.toString());
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Writing to XML file failed", e);
            }
        }

        @Override
        public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            try {
                if (this.filter(t)) {
                    this.writer.writeEmptyElement(t.toString());
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Writing to XML file failed", e);
            }
        }

        @Override
        public void handleEndTag(HTML.Tag t, int pos) {
            try {
                if (this.filter(t)) {
                    this.writer.writeEndElement();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Writing to XML file failed", e);
            }
        }

        @Override
        public void handleText(char[] data, int pos) {
            try {
                this.writer.writeCharacters(new String(data));
            }
            catch (Exception e) {
                throw new RuntimeException("Writing to XML file failed", e);
            }
        }

        private boolean filter(HTML.Tag t) {
            return !TAG_FILTER.contains(t.toString());
        }
    }
}

