/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import systems.dmx.core.impl.CoreEvent;
import systems.dmx.core.impl.PluginImpl;
import systems.dmx.core.osgi.PluginContext;
import systems.dmx.core.service.DMXEvent;
import systems.dmx.core.service.EventListener;
import systems.dmx.core.service.accesscontrol.AccessControlException;

class EventManager {
    private Map<String, List<EventListener>> listenerRegistry = new HashMap<String, List<EventListener>>();

    EventManager() {
        new CoreEvent();
    }

    void addListener(DMXEvent event, EventListener listener) {
        List<EventListener> listeners = this.getListeners(event);
        if (listeners == null) {
            listeners = new ArrayList<EventListener>();
            this.putListeners(event, listeners);
        }
        listeners.add(listener);
    }

    void removeListener(DMXEvent event, EventListener listener) {
        List<EventListener> listeners = this.getListeners(event);
        if (!listeners.remove(listener)) {
            throw new RuntimeException("Removing " + listener + " from " + event + " event listeners failed: not found in " + listeners);
        }
    }

    void fireEvent(DMXEvent event, Object ... params) {
        List<EventListener> listeners = this.getListeners(event);
        if (listeners != null) {
            for (EventListener listener : listeners) {
                this.dispatchEvent(listener, event, params);
            }
        }
    }

    void dispatchEvent(PluginImpl plugin, DMXEvent event, Object ... params) {
        PluginContext pluginContext = plugin.getContext();
        if (!this.isListener(pluginContext, event)) {
            return;
        }
        this.dispatchEvent((EventListener)((Object)pluginContext), event, params);
    }

    private void dispatchEvent(EventListener listener, DMXEvent event, Object ... params) {
        try {
            event.dispatch(listener, params);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (AccessControlException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("An error occurred in the " + event.getListenerInterface().getSimpleName() + " listener of " + listener, e);
        }
    }

    private boolean isListener(PluginContext pluginContext, DMXEvent event) {
        return event.getListenerInterface().isAssignableFrom(pluginContext.getClass());
    }

    private List<EventListener> getListeners(DMXEvent event) {
        return this.listenerRegistry.get(event.getClass().getName());
    }

    private void putListeners(DMXEvent event, List<EventListener> listeners) {
        this.listenerRegistry.put(event.getClass().getName(), listeners);
    }
}

