/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.impl.AssociationDefinitionModelImpl;
import de.deepamehta.core.impl.AssociationModelImpl;
import de.deepamehta.core.impl.AssociationTypeModelImpl;
import de.deepamehta.core.impl.ModelFactoryImpl;
import de.deepamehta.core.impl.PersistenceLayer;
import de.deepamehta.core.impl.RelatedAssociationModelImpl;
import de.deepamehta.core.impl.RelatedTopicModelImpl;
import de.deepamehta.core.impl.TopicModelImpl;
import de.deepamehta.core.impl.TopicTypeModelImpl;
import de.deepamehta.core.impl.TypeModelImpl;
import de.deepamehta.core.impl.ViewConfigurationModelImpl;
import de.deepamehta.core.model.AssociationDefinitionModel;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.AssociationTypeModel;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.DeepaMehtaObjectModel;
import de.deepamehta.core.model.IndexMode;
import de.deepamehta.core.model.RelatedTopicModel;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.TopicTypeModel;
import de.deepamehta.core.model.ViewConfigurationModel;
import de.deepamehta.core.util.DeepaMehtaUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

class TypeStorage {
    private static final String PARENT_CARDINALITY = "dm4.core.parent_cardinality";
    private static final String CHILD_CARDINALITY = "dm4.core.child_cardinality";
    private Map<String, TypeModelImpl> typeCache = new HashMap<String, TypeModelImpl>();
    private EndlessRecursionDetection endlessRecursionDetection = new EndlessRecursionDetection();
    private PersistenceLayer pl;
    private ModelFactoryImpl mf;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    TypeStorage(PersistenceLayer pl) {
        this.pl = pl;
        this.mf = pl.mf;
    }

    TopicTypeModelImpl getTopicType(String topicTypeUri) {
        TopicTypeModelImpl topicType = (TopicTypeModelImpl)this.getType(topicTypeUri);
        return topicType != null ? topicType : this.fetchTopicType(topicTypeUri);
    }

    AssociationTypeModelImpl getAssociationType(String assocTypeUri) {
        AssociationTypeModelImpl assocType = (AssociationTypeModelImpl)this.getType(assocTypeUri);
        return assocType != null ? assocType : this.fetchAssociationType(assocTypeUri);
    }

    void putInTypeCache(TypeModelImpl type) {
        this.typeCache.put(type.uri, type);
    }

    void removeFromTypeCache(String typeUri) {
        this.logger.info("### Removing type \"" + typeUri + "\" from type cache");
        if (this.typeCache.remove(typeUri) == null) {
            throw new RuntimeException("Type \"" + typeUri + "\" not found in type cache");
        }
    }

    TypeModelImpl getType(String typeUri) {
        return this.typeCache.get(typeUri);
    }

    private TopicTypeModelImpl fetchTopicType(String topicTypeUri) {
        try {
            this.logger.info("Fetching topic type \"" + topicTypeUri + "\"");
            this.endlessRecursionDetection.check(topicTypeUri);
            TopicModelImpl typeTopic = this.pl.fetchTopic("uri", new SimpleValue(topicTypeUri));
            this.checkTopicType(topicTypeUri, typeTopic);
            String dataTypeUri = this.fetchDataTypeTopic(typeTopic.getId(), topicTypeUri, "topic type").getUri();
            List<IndexMode> indexModes = this.fetchIndexModes(typeTopic.getId());
            List<AssociationDefinitionModel> assocDefs = this.fetchAssociationDefinitions(typeTopic);
            ViewConfigurationModel viewConfig = this.fetchTypeViewConfig(typeTopic);
            TopicTypeModel topicType = this.mf.newTopicTypeModel((TopicModel)typeTopic, dataTypeUri, (List)indexModes, (List)assocDefs, viewConfig);
            this.putInTypeCache((TypeModelImpl)((Object)topicType));
            TopicTypeModel topicTypeModel = topicType;
            return topicTypeModel;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topic type \"" + topicTypeUri + "\" failed", e);
        }
        finally {
            this.endlessRecursionDetection.reset(topicTypeUri);
        }
    }

    private AssociationTypeModelImpl fetchAssociationType(String assocTypeUri) {
        try {
            this.logger.info("Fetching association type \"" + assocTypeUri + "\"");
            this.endlessRecursionDetection.check(assocTypeUri);
            TopicModelImpl typeTopic = this.pl.fetchTopic("uri", new SimpleValue(assocTypeUri));
            this.checkAssociationType(assocTypeUri, typeTopic);
            String dataTypeUri = this.fetchDataTypeTopic(typeTopic.getId(), assocTypeUri, "association type").getUri();
            List<IndexMode> indexModes = this.fetchIndexModes(typeTopic.getId());
            List<AssociationDefinitionModel> assocDefs = this.fetchAssociationDefinitions(typeTopic);
            ViewConfigurationModel viewConfig = this.fetchTypeViewConfig(typeTopic);
            AssociationTypeModel assocType = this.mf.newAssociationTypeModel((TopicModel)typeTopic, dataTypeUri, (List)indexModes, (List)assocDefs, viewConfig);
            this.putInTypeCache((TypeModelImpl)((Object)assocType));
            AssociationTypeModel associationTypeModel = assocType;
            return associationTypeModel;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching association type \"" + assocTypeUri + "\" failed", e);
        }
        finally {
            this.endlessRecursionDetection.reset(assocTypeUri);
        }
    }

    private void checkTopicType(String topicTypeUri, TopicModel typeTopic) {
        if (typeTopic == null) {
            throw new RuntimeException("Topic type \"" + topicTypeUri + "\" not found in DB");
        }
        if (!(typeTopic.getTypeUri().equals("dm4.core.topic_type") || typeTopic.getTypeUri().equals("dm4.core.meta_type") || typeTopic.getTypeUri().equals("dm4.core.meta_meta_type"))) {
            throw new RuntimeException("URI \"" + topicTypeUri + "\" refers to a \"" + typeTopic.getTypeUri() + "\" when the caller expects a \"dm4.core.topic_type\"");
        }
    }

    private void checkAssociationType(String assocTypeUri, TopicModel typeTopic) {
        if (typeTopic == null) {
            throw new RuntimeException("Association type \"" + assocTypeUri + "\" not found in DB");
        }
        if (!typeTopic.getTypeUri().equals("dm4.core.assoc_type")) {
            throw new RuntimeException("URI \"" + assocTypeUri + "\" refers to a \"" + typeTopic.getTypeUri() + "\" when the caller expects a \"dm4.core.assoc_type\"");
        }
    }

    void storeType(TypeModelImpl type) {
        this.putInTypeCache(type);
        this.storeDataType(type.getUri(), type.getDataTypeUri());
        this.storeIndexModes(type.getUri(), type.getIndexModes());
        this.storeAssocDefs(type.getId(), type.getAssocDefs());
        this.storeViewConfig(this.newTypeRole(type.getId()), type.getViewConfig());
    }

    private RelatedTopicModel fetchDataTypeTopic(long typeId, String typeUri, String className) {
        try {
            RelatedTopicModelImpl dataType = this.pl.fetchTopicRelatedTopic(typeId, "dm4.core.aggregation", "dm4.core.type", "dm4.core.default", "dm4.core.data_type");
            if (dataType == null) {
                throw new RuntimeException("No data type topic is associated to " + className + " \"" + typeUri + "\"");
            }
            return dataType;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching the data type topic of " + className + " \"" + typeUri + "\" failed", e);
        }
    }

    void storeDataType(String typeUri, String dataTypeUri) {
        try {
            this.pl.createAssociation("dm4.core.aggregation", this.mf.newTopicRoleModel(typeUri, "dm4.core.type"), this.mf.newTopicRoleModel(dataTypeUri, "dm4.core.default"));
        }
        catch (Exception e) {
            throw new RuntimeException("Associating type \"" + typeUri + "\" with data type \"" + dataTypeUri + "\" failed", e);
        }
    }

    private List<IndexMode> fetchIndexModes(long typeId) {
        List<RelatedTopicModelImpl> indexModes = this.pl.fetchTopicRelatedTopics(typeId, "dm4.core.aggregation", "dm4.core.type", "dm4.core.default", "dm4.core.index_mode");
        return IndexMode.fromTopics(indexModes);
    }

    private void storeIndexModes(String typeUri, List<IndexMode> indexModes) {
        for (IndexMode indexMode : indexModes) {
            this.storeIndexMode(typeUri, indexMode);
        }
    }

    void storeIndexMode(String typeUri, IndexMode indexMode) {
        this.pl.createAssociation("dm4.core.aggregation", this.mf.newTopicRoleModel(typeUri, "dm4.core.type"), this.mf.newTopicRoleModel(indexMode.toUri(), "dm4.core.default"));
    }

    private String defaultCardinalityUri(AssociationModel assoc, String cardinalityRoleTypeUri) {
        RelatedTopicModelImpl cardinality = this.fetchCardinality(assoc.getId(), cardinalityRoleTypeUri);
        if (cardinality != null) {
            return cardinality.getUri();
        }
        return "dm4.core.one";
    }

    private List<AssociationDefinitionModel> fetchAssociationDefinitions(TopicModelImpl typeTopic) {
        Map<Long, AssociationDefinitionModel> assocDefs = this.fetchAssociationDefinitionsUnsorted(typeTopic);
        List<RelatedAssociationModelImpl> sequence = this.fetchSequence(typeTopic);
        if (assocDefs.size() != sequence.size()) {
            throw new RuntimeException("DB inconsistency: type \"" + typeTopic.getUri() + "\" has " + assocDefs.size() + " association definitions but in sequence are " + sequence.size());
        }
        return this.sortAssocDefs(assocDefs, DeepaMehtaUtils.idList(sequence));
    }

    private Map<Long, AssociationDefinitionModel> fetchAssociationDefinitionsUnsorted(TopicModelImpl typeTopic) {
        HashMap<Long, AssociationDefinitionModel> assocDefs = new HashMap<Long, AssociationDefinitionModel>();
        List<RelatedTopicModelImpl> childTypes = typeTopic.getRelatedTopics(Arrays.asList("dm4.core.aggregation_def", "dm4.core.composition_def"), "dm4.core.parent_type", "dm4.core.child_type", null);
        for (RelatedTopicModel relatedTopicModel : childTypes) {
            AssociationDefinitionModel assocDef = this.fetchAssociationDefinition(relatedTopicModel.getRelatingAssociation(), typeTopic.getUri(), relatedTopicModel.getUri());
            assocDefs.put(assocDef.getId(), assocDef);
        }
        return assocDefs;
    }

    AssociationDefinitionModelImpl newAssociationDefinition(AssociationModelImpl assoc) {
        AssociationModelImpl model = this.mf.newAssociationModel(assoc);
        String parentTypeUri = this.fetchParentTypeTopic(assoc).getUri();
        String childTypeUri = this.fetchChildTypeTopic(assoc).getUri();
        this.prepareAssocModel(model, parentTypeUri, childTypeUri);
        return this.mf.newAssociationDefinitionModel(model, this.defaultCardinalityUri(assoc, PARENT_CARDINALITY), this.defaultCardinalityUri(assoc, CHILD_CARDINALITY), null);
    }

    private AssociationDefinitionModel fetchAssociationDefinition(AssociationModel assoc, String parentTypeUri, String childTypeUri) {
        try {
            this.prepareAssocModel(assoc, parentTypeUri, childTypeUri);
            return this.mf.newAssociationDefinitionModel(assoc, this.fetchCardinalityOrThrow(assoc.getId(), PARENT_CARDINALITY).getUri(), this.fetchCardinalityOrThrow(assoc.getId(), CHILD_CARDINALITY).getUri(), this.fetchAssocDefViewConfig(assoc));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching association definition failed (parentTypeUri=\"" + parentTypeUri + "\", childTypeUri=" + childTypeUri + ", " + assoc + ")", e);
        }
    }

    private void prepareAssocModel(AssociationModel assoc, String parentTypeUri, String childTypeUri) {
        RelatedTopicModel includeInLabel;
        long assocDefId = assoc.getId();
        assoc.setRoleModel1(this.mf.newTopicRoleModel(parentTypeUri, "dm4.core.parent_type"));
        assoc.setRoleModel2(this.mf.newTopicRoleModel(childTypeUri, "dm4.core.child_type"));
        ChildTopicsModel childTopics = assoc.getChildTopicsModel();
        RelatedTopicModel customAssocType = this.fetchCustomAssocType(assocDefId);
        if (customAssocType != null) {
            childTopics.put("dm4.core.assoc_type#dm4.core.custom_assoc_type", customAssocType);
        }
        if ((includeInLabel = this.fetchIncludeInLabel(assocDefId)) != null) {
            childTopics.put("dm4.core.include_in_label", includeInLabel);
        }
    }

    private RelatedTopicModel fetchCustomAssocType(long assocDefId) {
        return this.pl.fetchAssociationRelatedTopic(assocDefId, "dm4.core.custom_assoc_type", "dm4.core.parent", "dm4.core.child", "dm4.core.assoc_type");
    }

    private RelatedTopicModel fetchIncludeInLabel(long assocDefId) {
        return this.pl.fetchAssociationRelatedTopic(assocDefId, "dm4.core.composition", "dm4.core.parent", "dm4.core.child", "dm4.core.include_in_label");
    }

    private List<AssociationDefinitionModel> sortAssocDefs(Map<Long, AssociationDefinitionModel> assocDefs, List<Long> sequence) {
        ArrayList<AssociationDefinitionModel> sortedAssocDefs = new ArrayList<AssociationDefinitionModel>();
        for (long assocDefId : sequence) {
            AssociationDefinitionModel assocDef = assocDefs.get(assocDefId);
            if (assocDef == null) {
                throw new RuntimeException("DB inconsistency: ID " + assocDefId + " is in sequence but not in the type's association definitions");
            }
            sortedAssocDefs.add(assocDef);
        }
        return sortedAssocDefs;
    }

    private void storeAssocDefs(long typeId, Collection<AssociationDefinitionModelImpl> assocDefs) {
        for (AssociationDefinitionModelImpl assocDef : assocDefs) {
            this.storeAssociationDefinition(assocDef);
        }
        this.storeSequence(typeId, assocDefs);
    }

    void storeAssociationDefinition(AssociationDefinitionModelImpl assocDef) {
        try {
            long assocDefId = assocDef.getId();
            if (assocDefId == -1L) {
                assocDefId = this.pl.createAssociation(assocDef).getId();
            }
            this.removeCardinalityAssignmentIfExists(assocDefId, PARENT_CARDINALITY);
            this.removeCardinalityAssignmentIfExists(assocDefId, CHILD_CARDINALITY);
            this.associateCardinality(assocDefId, PARENT_CARDINALITY, assocDef.getParentCardinalityUri());
            this.associateCardinality(assocDefId, CHILD_CARDINALITY, assocDef.getChildCardinalityUri());
            this.storeViewConfig(this.newAssocDefRole(assocDefId), assocDef.getViewConfigModel());
        }
        catch (Exception e) {
            throw new RuntimeException("Storing association definition \"" + assocDef.getAssocDefUri() + "\" of type \"" + assocDef.getParentTypeUri() + "\" failed", e);
        }
    }

    private TopicModel fetchParentTypeTopic(AssociationModelImpl assoc) {
        TopicModel parentType = (TopicModel)((Object)assoc.getPlayer("dm4.core.parent_type"));
        if (parentType == null) {
            throw new RuntimeException("DB inconsistency: topic role \"dm4.core.parent_type\" is missing in " + assoc);
        }
        return parentType;
    }

    private TopicModel fetchChildTypeTopic(AssociationModelImpl assoc) {
        TopicModel childType = (TopicModel)((Object)assoc.getPlayer("dm4.core.child_type"));
        if (childType == null) {
            throw new RuntimeException("DB inconsistency: topic role \"dm4.core.child_type\" is missing in " + assoc);
        }
        return childType;
    }

    TypeModelImpl fetchParentType(AssociationModelImpl assoc) {
        TopicModel type = this.fetchParentTypeTopic(assoc);
        String typeUri = type.getTypeUri();
        if (typeUri.equals("dm4.core.topic_type")) {
            return this.getTopicType(type.getUri());
        }
        if (typeUri.equals("dm4.core.assoc_type")) {
            return this.getAssociationType(type.getUri());
        }
        throw new RuntimeException("DB inconsistency: the \"dm4.core.parent_type\" player is not a type but of type \"" + typeUri + "\" in " + assoc);
    }

    private RelatedTopicModelImpl fetchCardinality(long assocDefId, String cardinalityRoleTypeUri) {
        return this.pl.fetchAssociationRelatedTopic(assocDefId, "dm4.core.aggregation", "dm4.core.assoc_def", cardinalityRoleTypeUri, "dm4.core.cardinality");
    }

    private RelatedTopicModelImpl fetchCardinalityOrThrow(long assocDefId, String cardinalityRoleTypeUri) {
        RelatedTopicModelImpl cardinality = this.fetchCardinality(assocDefId, cardinalityRoleTypeUri);
        if (cardinality == null) {
            throw new RuntimeException("DB inconsistency: association definition " + assocDefId + " is missing a cardinality (\"" + cardinalityRoleTypeUri + "\")");
        }
        return cardinality;
    }

    void storeParentCardinalityUri(long assocDefId, String parentCardinalityUri) {
        this.storeCardinalityUri(assocDefId, PARENT_CARDINALITY, parentCardinalityUri);
    }

    void storeChildCardinalityUri(long assocDefId, String childCardinalityUri) {
        this.storeCardinalityUri(assocDefId, CHILD_CARDINALITY, childCardinalityUri);
    }

    private void storeCardinalityUri(long assocDefId, String cardinalityRoleTypeUri, String cardinalityUri) {
        RelatedTopicModelImpl cardinality = this.fetchCardinalityOrThrow(assocDefId, cardinalityRoleTypeUri);
        this.removeCardinalityAssignment(cardinality);
        this.associateCardinality(assocDefId, cardinalityRoleTypeUri, cardinalityUri);
    }

    private void removeCardinalityAssignmentIfExists(long assocDefId, String cardinalityRoleTypeUri) {
        RelatedTopicModelImpl cardinality = this.fetchCardinality(assocDefId, cardinalityRoleTypeUri);
        if (cardinality != null) {
            this.removeCardinalityAssignment(cardinality);
        }
    }

    private void removeCardinalityAssignment(RelatedTopicModelImpl cardinalityAssignment) {
        cardinalityAssignment.getRelatingAssociation().delete();
    }

    private void associateCardinality(long assocDefId, String cardinalityRoleTypeUri, String cardinalityUri) {
        this.pl.createAssociation("dm4.core.aggregation", this.mf.newTopicRoleModel(cardinalityUri, cardinalityRoleTypeUri), this.mf.newAssociationRoleModel(assocDefId, "dm4.core.assoc_def"));
    }

    private List<RelatedAssociationModelImpl> fetchSequence(TopicModel typeTopic) {
        try {
            ArrayList<RelatedAssociationModelImpl> sequence = new ArrayList<RelatedAssociationModelImpl>();
            RelatedAssociationModelImpl assocDef = this.fetchSequenceStart(typeTopic.getId());
            if (assocDef != null) {
                sequence.add(assocDef);
                while ((assocDef = this.fetchSuccessor(assocDef.getId())) != null) {
                    sequence.add(assocDef);
                }
            }
            return sequence;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching sequence for type \"" + typeTopic.getUri() + "\" failed", e);
        }
    }

    private RelatedAssociationModelImpl fetchSequenceStart(long typeId) {
        return this.pl.fetchTopicRelatedAssociation(typeId, "dm4.core.aggregation", "dm4.core.type", "dm4.core.sequence_start", null);
    }

    private RelatedAssociationModelImpl fetchSuccessor(long assocDefId) {
        return this.pl.fetchAssociationRelatedAssociation(assocDefId, "dm4.core.sequence", "dm4.core.predecessor", "dm4.core.successor", null);
    }

    private RelatedAssociationModelImpl fetchPredecessor(long assocDefId) {
        return this.pl.fetchAssociationRelatedAssociation(assocDefId, "dm4.core.sequence", "dm4.core.successor", "dm4.core.predecessor", null);
    }

    private void storeSequence(long typeId, Collection<AssociationDefinitionModelImpl> assocDefs) {
        this.logger.fine("### Storing " + assocDefs.size() + " sequence segments for type " + typeId);
        long predAssocDefId = -1L;
        for (AssociationDefinitionModel associationDefinitionModel : assocDefs) {
            this.addAssocDefToSequence(typeId, associationDefinitionModel.getId(), -1L, -1L, predAssocDefId);
            predAssocDefId = associationDefinitionModel.getId();
        }
    }

    void addAssocDefToSequence(long typeId, long assocDefId, long beforeAssocDefId, long firstAssocDefId, long lastAssocDefId) {
        if (beforeAssocDefId == -1L) {
            this.appendToSequence(typeId, assocDefId, lastAssocDefId);
        } else if (firstAssocDefId == assocDefId) {
            this.insertAtSequenceStart(typeId, assocDefId);
        } else {
            this.insertIntoSequence(assocDefId, beforeAssocDefId);
        }
    }

    private void appendToSequence(long typeId, long assocDefId, long predAssocDefId) {
        if (predAssocDefId == -1L) {
            this.storeSequenceStart(typeId, assocDefId);
        } else {
            this.storeSequenceSegment(predAssocDefId, assocDefId);
        }
    }

    private void insertAtSequenceStart(long typeId, long assocDefId) {
        RelatedAssociationModelImpl assocDef = this.fetchSequenceStart(typeId);
        assocDef.getRelatingAssociation().delete();
        this.storeSequenceStart(typeId, assocDefId);
        this.storeSequenceSegment(assocDefId, assocDef.getId());
    }

    private void insertIntoSequence(long assocDefId, long beforeAssocDefId) {
        RelatedAssociationModelImpl assocDef = this.fetchPredecessor(beforeAssocDefId);
        assocDef.getRelatingAssociation().delete();
        this.storeSequenceSegment(assocDef.getId(), assocDefId);
        this.storeSequenceSegment(assocDefId, beforeAssocDefId);
    }

    private void storeSequenceStart(long typeId, long assocDefId) {
        this.pl.createAssociation("dm4.core.aggregation", this.mf.newTopicRoleModel(typeId, "dm4.core.type"), this.mf.newAssociationRoleModel(assocDefId, "dm4.core.sequence_start"));
    }

    private void storeSequenceSegment(long predAssocDefId, long succAssocDefId) {
        this.pl.createAssociation("dm4.core.sequence", this.mf.newAssociationRoleModel(predAssocDefId, "dm4.core.predecessor"), this.mf.newAssociationRoleModel(succAssocDefId, "dm4.core.successor"));
    }

    void rebuildSequence(TypeModelImpl type) {
        this.deleteSequence(type);
        this.storeSequence(type.getId(), type.getAssocDefs());
    }

    private void deleteSequence(TopicModel typeTopic) {
        List<RelatedAssociationModelImpl> sequence = this.fetchSequence(typeTopic);
        this.logger.info("### Deleting " + sequence.size() + " sequence segments of type \"" + typeTopic.getUri() + "\"");
        for (RelatedAssociationModelImpl assoc : sequence) {
            assoc.getRelatingAssociation().delete();
        }
    }

    private ViewConfigurationModel fetchTypeViewConfig(TopicModel typeTopic) {
        try {
            return this.viewConfigModel(this.pl.fetchTopicRelatedTopics(typeTopic.getId(), "dm4.core.aggregation", "dm4.core.type", "dm4.core.view_config", null));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching view configuration for type \"" + typeTopic.getUri() + "\" failed", e);
        }
    }

    private ViewConfigurationModel fetchAssocDefViewConfig(AssociationModel assocDef) {
        try {
            return this.viewConfigModel(this.pl.fetchAssociationRelatedTopics(assocDef.getId(), "dm4.core.aggregation", "dm4.core.assoc_def", "dm4.core.view_config", null));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching view configuration for assoc def " + assocDef.getId() + " failed", e);
        }
    }

    private ViewConfigurationModel viewConfigModel(Iterable<? extends TopicModel> configTopics) {
        this.fetchChildTopics(configTopics);
        return this.mf.newViewConfigurationModel((Iterable)configTopics);
    }

    private void storeViewConfig(RoleModel configurable, ViewConfigurationModelImpl viewConfig) {
        try {
            for (TopicModelImpl configTopic : viewConfig.getConfigTopics()) {
                this.storeViewConfigTopic(configurable, configTopic);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Storing view configuration failed (configurable=" + configurable + ", viewConfig=" + viewConfig + ")", e);
        }
    }

    void storeViewConfigTopic(RoleModel configurable, TopicModelImpl configTopic) {
        this.pl.createTopic(configTopic);
        this.pl.createAssociation("dm4.core.aggregation", configurable, this.mf.newTopicRoleModel(configTopic.getId(), "dm4.core.view_config"));
    }

    private void fetchChildTopics(Iterable<? extends DeepaMehtaObjectModel> objects) {
        for (DeepaMehtaObjectModel deepaMehtaObjectModel : objects) {
            this.pl.valueStorage.fetchChildTopics(deepaMehtaObjectModel);
        }
    }

    RoleModel newTypeRole(long typeId) {
        return this.mf.newTopicRoleModel(typeId, "dm4.core.type");
    }

    RoleModel newAssocDefRole(long assocDefId) {
        return this.mf.newAssociationRoleModel(assocDefId, "dm4.core.assoc_def");
    }

    private static final class EndlessRecursionDetection {
        private Map<String, Boolean> loadInProgress = new HashMap<String, Boolean>();

        private EndlessRecursionDetection() {
        }

        private void check(String typeUri) {
            if (this.loadInProgress.get(typeUri) != null) {
                throw new RuntimeException("Endless recursion detected while loading type \"" + typeUri + "\"");
            }
            this.loadInProgress.put(typeUri, true);
        }

        private void reset(String typeUri) {
            this.loadInProgress.remove(typeUri);
        }
    }
}

