/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.impl.CoreServiceImpl;
import de.deepamehta.core.impl.PluginImpl;
import de.deepamehta.core.service.Migration;
import de.deepamehta.core.service.ModelFactory;
import de.deepamehta.core.service.Plugin;
import de.deepamehta.core.util.JavaUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Properties;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;

class MigrationManager {
    private static final String CORE_MIGRATIONS_PACKAGE = "de.deepamehta.core.migrations";
    private static final int CORE_MODEL_VERSION = 7;
    private CoreServiceImpl dm4;
    private ModelFactory mf;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    MigrationManager(CoreServiceImpl dm4) {
        this.dm4 = dm4;
        this.mf = dm4.mf;
    }

    void runPluginMigrations(PluginImpl plugin, boolean isCleanInstall) {
        int installedModelVersion = plugin.getPluginTopic().getChildTopics().getTopic("dm4.core.plugin_migration_nr").getSimpleValue().intValue();
        int requiredModelVersion = Integer.parseInt(plugin.getConfigProperty("dm4.plugin.model_version", "0"));
        int migrationsToRun = requiredModelVersion - installedModelVersion;
        if (migrationsToRun == 0) {
            this.logger.info("Running migrations for " + plugin + " SKIPPED -- installed model is up-to-date (version " + installedModelVersion + ")");
            return;
        }
        this.logger.info("Running " + migrationsToRun + " migrations for " + plugin + " (installed model: version " + installedModelVersion + ", required model: version " + requiredModelVersion + ")");
        for (int i = installedModelVersion + 1; i <= requiredModelVersion; ++i) {
            this.runPluginMigration(plugin, i, isCleanInstall);
        }
    }

    void runCoreMigrations(boolean isCleanInstall) {
        int requiredModelVersion = 7;
        int installedModelVersion = this.dm4.pl.fetchMigrationNr();
        int migrationsToRun = requiredModelVersion - installedModelVersion;
        if (migrationsToRun == 0) {
            this.logger.info("Running core migrations SKIPPED -- installed model is up-to-date (version " + installedModelVersion + ")");
            return;
        }
        this.logger.info("Running " + migrationsToRun + " core migrations (installed model: version " + installedModelVersion + ", required model: version " + requiredModelVersion + ")");
        for (int i = installedModelVersion + 1; i <= requiredModelVersion; ++i) {
            this.runCoreMigration(i, isCleanInstall);
        }
    }

    private void runCoreMigration(int migrationNr, boolean isCleanInstall) {
        this.runMigration(migrationNr, null, isCleanInstall);
        this.dm4.pl.storeMigrationNr(migrationNr);
    }

    private void runPluginMigration(PluginImpl plugin, int migrationNr, boolean isCleanInstall) {
        this.runMigration(migrationNr, plugin, isCleanInstall);
        plugin.setMigrationNr(migrationNr);
    }

    private void runMigration(int migrationNr, PluginImpl plugin, boolean isCleanInstall) {
        MigrationInfo mi = null;
        try {
            mi = new MigrationInfo(migrationNr, plugin);
            if (!mi.success) {
                throw mi.exception;
            }
            mi.checkValidity();
            String runInfo = " (runMode=" + mi.runMode + ", isCleanInstall=" + isCleanInstall + ")";
            if (mi.runMode.equals(MigrationRunMode.CLEAN_INSTALL.name()) == isCleanInstall || mi.runMode.equals(MigrationRunMode.ALWAYS.name())) {
                this.logger.info("Running " + mi.migrationInfo + runInfo);
                if (mi.isDeclarative) {
                    this.readMigrationFile(mi.migrationIn, mi.migrationFile);
                } else {
                    Migration migration = (Migration)mi.migrationClass.newInstance();
                    this.injectServices(migration, mi.migrationInfo, plugin);
                    migration.setCoreService(this.dm4);
                    this.logger.info("Running " + mi.migrationType + " migration class " + mi.migrationClassName);
                    migration.run();
                }
            } else {
                this.logger.info("Running " + mi.migrationInfo + " SKIPPED" + runInfo);
            }
            this.logger.info("Updating installed model: version " + migrationNr);
        }
        catch (Exception e) {
            throw new RuntimeException("Running " + mi.migrationInfo + " failed", e);
        }
    }

    private void injectServices(Migration migration, String migrationInfo, PluginImpl plugin) {
        try {
            for (Field field : PluginImpl.getInjectableFields(migration.getClass())) {
                Class<?> serviceInterface = field.getType();
                Object service = serviceInterface.getName().equals(plugin.getProvidedServiceInterface()) ? plugin.getContext() : plugin.getInjectedService(serviceInterface);
                this.logger.info("Injecting service " + serviceInterface.getName() + " into " + migrationInfo);
                field.set(migration, service);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Injecting services into " + migrationInfo + " failed", e);
        }
    }

    private void readMigrationFile(InputStream in, String migrationFileName) {
        block4: {
            try {
                this.logger.info("Reading migration file \"" + migrationFileName + "\"");
                String fileContent = JavaUtils.readText(in);
                Object value = new JSONTokener(fileContent).nextValue();
                if (value instanceof JSONObject) {
                    this.readEntities((JSONObject)value);
                    break block4;
                }
                if (value instanceof JSONArray) {
                    this.readEntities((JSONArray)value);
                    break block4;
                }
                throw new RuntimeException("Invalid file content");
            }
            catch (Exception e) {
                throw new RuntimeException("Reading migration file \"" + migrationFileName + "\" failed", e);
            }
        }
    }

    private void readEntities(JSONArray entities) throws JSONException {
        for (int i = 0; i < entities.length(); ++i) {
            this.readEntities(entities.getJSONObject(i));
        }
    }

    private void readEntities(JSONObject entities) throws JSONException {
        JSONArray assocs;
        JSONArray topics;
        JSONArray assocTypes;
        JSONArray topicTypes = entities.optJSONArray("topic_types");
        if (topicTypes != null) {
            this.createTopicTypes(topicTypes);
        }
        if ((assocTypes = entities.optJSONArray("assoc_types")) != null) {
            this.createAssociationTypes(assocTypes);
        }
        if ((topics = entities.optJSONArray("topics")) != null) {
            this.createTopics(topics);
        }
        if ((assocs = entities.optJSONArray("associations")) != null) {
            this.createAssociations(assocs);
        }
    }

    private void createTopicTypes(JSONArray topicTypes) throws JSONException {
        for (int i = 0; i < topicTypes.length(); ++i) {
            this.dm4.createTopicType(this.mf.newTopicTypeModel(topicTypes.getJSONObject(i)));
        }
    }

    private void createAssociationTypes(JSONArray assocTypes) throws JSONException {
        for (int i = 0; i < assocTypes.length(); ++i) {
            this.dm4.createAssociationType(this.mf.newAssociationTypeModel(assocTypes.getJSONObject(i)));
        }
    }

    private void createTopics(JSONArray topics) throws JSONException {
        for (int i = 0; i < topics.length(); ++i) {
            this.dm4.createTopic(this.mf.newTopicModel(topics.getJSONObject(i)));
        }
    }

    private void createAssociations(JSONArray assocs) throws JSONException {
        for (int i = 0; i < assocs.length(); ++i) {
            this.dm4.createAssociation(this.mf.newAssociationModel(assocs.getJSONObject(i)));
        }
    }

    private class MigrationInfo {
        String migrationType;
        String migrationInfo;
        String runMode;
        boolean isDeclarative;
        boolean isImperative;
        String migrationFile;
        InputStream migrationIn;
        String migrationClassName;
        Class migrationClass;
        boolean success;
        Exception exception;

        MigrationInfo(int migrationNr, PluginImpl plugin) {
            try {
                InputStream configIn;
                String configFile = this.migrationConfigFile(migrationNr);
                this.migrationFile = this.migrationFile(migrationNr);
                String string = this.migrationType = plugin != null ? "plugin" : "core";
                if (this.migrationType.equals("core")) {
                    this.migrationInfo = "core migration " + migrationNr;
                    configIn = this.getClass().getResourceAsStream(configFile);
                    this.migrationIn = this.getClass().getResourceAsStream(this.migrationFile);
                    this.migrationClassName = this.coreMigrationClassName(migrationNr);
                    this.migrationClass = this.loadClass(this.migrationClassName);
                } else {
                    this.migrationInfo = "migration " + migrationNr + " of " + plugin;
                    configIn = this.getStaticResourceOrNull(plugin, configFile);
                    this.migrationIn = this.getStaticResourceOrNull(plugin, this.migrationFile);
                    this.migrationClassName = plugin.getMigrationClassName(migrationNr);
                    if (this.migrationClassName != null) {
                        this.migrationClass = plugin.loadClass(this.migrationClassName);
                    }
                }
                this.isDeclarative = this.migrationIn != null;
                this.isImperative = this.migrationClass != null;
                this.readMigrationConfigFile(configIn, configFile);
                this.success = true;
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        private void checkValidity() {
            if (!this.isDeclarative && !this.isImperative) {
                String message = "Neither a migration file (" + this.migrationFile + ") nor a migration class ";
                if (this.migrationClassName != null) {
                    throw new RuntimeException(message + "(" + this.migrationClassName + ") is found");
                }
                throw new RuntimeException(message + "is found. Note: a possible migration class can't be located (plugin package is unknown). Consider setting \"dm4.plugin.main_package\" in plugin.properties");
            }
            if (this.isDeclarative && this.isImperative) {
                throw new RuntimeException("Ambiguity: a migration file (" + this.migrationFile + ") AND a migration class (" + this.migrationClassName + ") are found. Consider using two different migration numbers.");
            }
        }

        private void readMigrationConfigFile(InputStream in, String configFile) {
            try {
                Properties migrationConfig = new Properties();
                if (in != null) {
                    MigrationManager.this.logger.info("Reading migration config file \"" + configFile + "\"");
                    migrationConfig.load(in);
                } else {
                    MigrationManager.this.logger.info("Reading migration config file \"" + configFile + "\" SKIPPED -- file does not exist");
                }
                this.runMode = migrationConfig.getProperty("migrationRunMode", MigrationRunMode.ALWAYS.name());
                MigrationRunMode.valueOf(this.runMode);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Reading migration config file \"" + configFile + "\" failed: \"" + this.runMode + "\" is an invalid value for \"migrationRunMode\"", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Reading migration config file \"" + configFile + "\" failed", e);
            }
        }

        private String migrationFile(int migrationNr) {
            return "/migrations/migration" + migrationNr + ".json";
        }

        private String migrationConfigFile(int migrationNr) {
            return "/migrations/migration" + migrationNr + ".properties";
        }

        private String coreMigrationClassName(int migrationNr) {
            return "de.deepamehta.core.migrations.Migration" + migrationNr;
        }

        private InputStream getStaticResourceOrNull(Plugin plugin, String resourceName) {
            if (plugin.hasStaticResource(resourceName)) {
                return plugin.getStaticResource(resourceName);
            }
            return null;
        }

        private Class loadClass(String className) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    }

    private static enum MigrationRunMode {
        CLEAN_INSTALL,
        UPDATE,
        ALWAYS;

    }
}

