/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.topicmaps;

import de.deepamehta.core.Association;
import de.deepamehta.core.RelatedAssociation;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.topicmaps.AssociationViewModel;
import de.deepamehta.core.model.topicmaps.TopicViewModel;
import de.deepamehta.core.model.topicmaps.ViewProperties;
import de.deepamehta.core.osgi.PluginActivator;
import de.deepamehta.core.service.Transactional;
import de.deepamehta.core.util.DeepaMehtaUtils;
import de.deepamehta.topicmaps.ClusterCoords;
import de.deepamehta.topicmaps.DefaultTopicmapRenderer;
import de.deepamehta.topicmaps.TopicmapRenderer;
import de.deepamehta.topicmaps.TopicmapsService;
import de.deepamehta.topicmaps.ViewmodelCustomizer;
import de.deepamehta.topicmaps.model.TopicmapViewmodel;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/topicmap")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class TopicmapsPlugin
extends PluginActivator
implements TopicmapsService {
    private static final String TOPIC_MAPCONTEXT = "dm4.topicmaps.topic_mapcontext";
    private static final String ASSOCIATION_MAPCONTEXT = "dm4.topicmaps.association_mapcontext";
    private static final String ROLE_TYPE_TOPICMAP = "dm4.core.default";
    private static final String ROLE_TYPE_TOPIC = "dm4.topicmaps.topicmap_topic";
    private static final String ROLE_TYPE_ASSOCIATION = "dm4.topicmaps.topicmap_association";
    private static final String PROP_X = "dm4.topicmaps.x";
    private static final String PROP_Y = "dm4.topicmaps.y";
    private static final String PROP_VISIBILITY = "dm4.topicmaps.visibility";
    private Map<String, TopicmapRenderer> topicmapRenderers = new HashMap<String, TopicmapRenderer>();
    private List<ViewmodelCustomizer> viewmodelCustomizers = new ArrayList<ViewmodelCustomizer>();
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public TopicmapsPlugin() {
        this.registerTopicmapRenderer(new DefaultTopicmapRenderer());
    }

    @Override
    @POST
    @Transactional
    public Topic createTopicmap(@QueryParam(value="name") String name, @QueryParam(value="renderer_uri") String topicmapRendererUri, @QueryParam(value="private") boolean isPrivate) {
        this.logger.info("Creating topicmap \"" + name + "\" (topicmapRendererUri=\"" + topicmapRendererUri + "\", isPrivate=" + isPrivate + ")");
        return this.dm4.createTopic(this.mf.newTopicModel("dm4.topicmaps.topicmap", this.mf.newChildTopicsModel().put("dm4.topicmaps.name", (Object)name).put("dm4.topicmaps.topicmap_renderer_uri", (Object)topicmapRendererUri).put("dm4.topicmaps.private", (Object)isPrivate).put("dm4.topicmaps.state", this.getTopicmapRenderer(topicmapRendererUri).initialTopicmapState(this.mf))));
    }

    @Override
    @GET
    @Path(value="/{id}")
    public TopicmapViewmodel getTopicmap(@PathParam(value="id") long topicmapId, @QueryParam(value="include_childs") boolean includeChilds) {
        try {
            this.logger.info("Loading topicmap " + topicmapId + " (includeChilds=" + includeChilds + ")");
            Topic topicmapTopic = this.dm4.getTopic(topicmapId).loadChildTopics();
            Map<Long, TopicViewModel> topics = this.fetchTopics(topicmapTopic, includeChilds);
            Map<Long, AssociationViewModel> assocs = this.fetchAssociations(topicmapTopic);
            return new TopicmapViewmodel(topicmapTopic.getModel(), topics, assocs);
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topicmap " + topicmapId + " failed", e);
        }
    }

    @Override
    public boolean isTopicInTopicmap(long topicmapId, long topicId) {
        return this.fetchTopicRefAssociation(topicmapId, topicId) != null;
    }

    @Override
    public boolean isAssociationInTopicmap(long topicmapId, long assocId) {
        return this.fetchAssociationRefAssociation(topicmapId, assocId) != null;
    }

    @Override
    @POST
    @Path(value="/{id}/topic/{topic_id}")
    @Transactional
    public void addTopicToTopicmap(final @PathParam(value="id") long topicmapId, final @PathParam(value="topic_id") long topicId, final ViewProperties viewProps) {
        try {
            this.dm4.getAccessControl().runWithoutWorkspaceAssignment((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    if (TopicmapsPlugin.this.isTopicInTopicmap(topicmapId, topicId)) {
                        throw new RuntimeException("The topic is already added");
                    }
                    Association assoc = TopicmapsPlugin.this.dm4.createAssociation(TopicmapsPlugin.this.mf.newAssociationModel(TopicmapsPlugin.TOPIC_MAPCONTEXT, (RoleModel)TopicmapsPlugin.this.mf.newTopicRoleModel(topicmapId, TopicmapsPlugin.ROLE_TYPE_TOPICMAP), (RoleModel)TopicmapsPlugin.this.mf.newTopicRoleModel(topicId, TopicmapsPlugin.ROLE_TYPE_TOPIC)));
                    TopicmapsPlugin.this.storeViewProperties(assoc, viewProps);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Adding topic " + topicId + " to topicmap " + topicmapId + " failed (viewProps=" + viewProps + ")", e);
        }
    }

    @Override
    public void addTopicToTopicmap(long topicmapId, long topicId, int x, int y, boolean visibility) {
        this.addTopicToTopicmap(topicmapId, topicId, new ViewProperties(x, y, visibility));
    }

    @Override
    @POST
    @Path(value="/{id}/association/{assoc_id}")
    @Transactional
    public void addAssociationToTopicmap(final @PathParam(value="id") long topicmapId, final @PathParam(value="assoc_id") long assocId) {
        try {
            this.dm4.getAccessControl().runWithoutWorkspaceAssignment((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    if (TopicmapsPlugin.this.isAssociationInTopicmap(topicmapId, assocId)) {
                        throw new RuntimeException("The association is already added");
                    }
                    TopicmapsPlugin.this.dm4.createAssociation(TopicmapsPlugin.this.mf.newAssociationModel(TopicmapsPlugin.ASSOCIATION_MAPCONTEXT, (RoleModel)TopicmapsPlugin.this.mf.newTopicRoleModel(topicmapId, TopicmapsPlugin.ROLE_TYPE_TOPICMAP), (RoleModel)TopicmapsPlugin.this.mf.newAssociationRoleModel(assocId, TopicmapsPlugin.ROLE_TYPE_ASSOCIATION)));
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Adding association " + assocId + " to topicmap " + topicmapId + " failed", e);
        }
    }

    @Override
    @PUT
    @Path(value="/{id}/topic/{topic_id}")
    @Transactional
    public void setViewProperties(@PathParam(value="id") long topicmapId, @PathParam(value="topic_id") long topicId, ViewProperties viewProps) {
        this.storeViewProperties(topicmapId, topicId, viewProps);
    }

    @Override
    @PUT
    @Path(value="/{id}/topic/{topic_id}/{x}/{y}")
    @Transactional
    public void setTopicPosition(@PathParam(value="id") long topicmapId, @PathParam(value="topic_id") long topicId, @PathParam(value="x") int x, @PathParam(value="y") int y) {
        this.storeViewProperties(topicmapId, topicId, new ViewProperties(x, y));
    }

    @Override
    @PUT
    @Path(value="/{id}/topic/{topic_id}/{visibility}")
    @Transactional
    public void setTopicVisibility(@PathParam(value="id") long topicmapId, @PathParam(value="topic_id") long topicId, @PathParam(value="visibility") boolean visibility) {
        this.storeViewProperties(topicmapId, topicId, new ViewProperties(visibility));
    }

    @Override
    @DELETE
    @Path(value="/{id}/association/{assoc_id}")
    @Transactional
    public void removeAssociationFromTopicmap(@PathParam(value="id") long topicmapId, @PathParam(value="assoc_id") long assocId) {
        try {
            Association assoc = this.fetchAssociationRefAssociation(topicmapId, assocId);
            if (assoc == null) {
                throw new RuntimeException("Association " + assocId + " is not contained in topicmap " + topicmapId);
            }
            this.dm4.getAccessControl().deleteAssociationMapcontext(assoc);
        }
        catch (Exception e) {
            throw new RuntimeException("Removing association " + assocId + " from topicmap " + topicmapId + " failed ", e);
        }
    }

    @Override
    @PUT
    @Path(value="/{id}")
    @Transactional
    public void setClusterPosition(@PathParam(value="id") long topicmapId, ClusterCoords coords) {
        for (ClusterCoords.Entry entry : coords) {
            this.setTopicPosition(topicmapId, entry.topicId, entry.x, entry.y);
        }
    }

    @Override
    @PUT
    @Path(value="/{id}/translation/{x}/{y}")
    @Transactional
    public void setTopicmapTranslation(@PathParam(value="id") long topicmapId, @PathParam(value="x") int transX, @PathParam(value="y") int transY) {
        try {
            ChildTopicsModel topicmapState = this.mf.newChildTopicsModel().put("dm4.topicmaps.state", this.mf.newChildTopicsModel().put("dm4.topicmaps.translation", this.mf.newChildTopicsModel().put("dm4.topicmaps.translation_x", (Object)transX).put("dm4.topicmaps.translation_y", (Object)transY)));
            this.dm4.updateTopic(this.mf.newTopicModel(topicmapId, topicmapState));
        }
        catch (Exception e) {
            throw new RuntimeException("Setting translation of topicmap " + topicmapId + " failed (transX=" + transX + ", transY=" + transY + ")", e);
        }
    }

    @Override
    public void registerTopicmapRenderer(TopicmapRenderer renderer) {
        this.logger.info("### Registering topicmap renderer \"" + renderer.getClass().getName() + "\"");
        this.topicmapRenderers.put(renderer.getUri(), renderer);
    }

    @Override
    public void registerViewmodelCustomizer(ViewmodelCustomizer customizer) {
        this.logger.info("### Registering viewmodel customizer \"" + customizer.getClass().getName() + "\"");
        this.viewmodelCustomizers.add(customizer);
    }

    @Override
    public void unregisterViewmodelCustomizer(ViewmodelCustomizer customizer) {
        this.logger.info("### Unregistering viewmodel customizer \"" + customizer.getClass().getName() + "\"");
        if (!this.viewmodelCustomizers.remove(customizer)) {
            throw new RuntimeException("Unregistering viewmodel customizer failed (customizer=" + customizer + ")");
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"text/html"})
    public InputStream getTopicmapInWebclient() {
        return this.invokeWebclient();
    }

    @GET
    @Path(value="/{id}/topic/{topic_id}")
    @Produces(value={"text/html"})
    public InputStream getTopicmapAndTopicInWebclient() {
        return this.invokeWebclient();
    }

    private Map<Long, TopicViewModel> fetchTopics(Topic topicmapTopic, boolean includeChilds) {
        HashMap<Long, TopicViewModel> topics = new HashMap<Long, TopicViewModel>();
        List relTopics = topicmapTopic.getRelatedTopics(TOPIC_MAPCONTEXT, ROLE_TYPE_TOPICMAP, ROLE_TYPE_TOPIC, null);
        if (includeChilds) {
            DeepaMehtaUtils.loadChildTopics((List)relTopics);
        }
        for (RelatedTopic topic : relTopics) {
            topics.put(topic.getId(), this.createTopicViewModel(topic));
        }
        return topics;
    }

    private Map<Long, AssociationViewModel> fetchAssociations(Topic topicmapTopic) {
        HashMap<Long, AssociationViewModel> assocs = new HashMap<Long, AssociationViewModel>();
        List relAssocs = topicmapTopic.getRelatedAssociations(ASSOCIATION_MAPCONTEXT, ROLE_TYPE_TOPICMAP, ROLE_TYPE_ASSOCIATION, null);
        for (RelatedAssociation assoc : relAssocs) {
            assocs.put(assoc.getId(), this.mf.newAssociationViewModel((AssociationModel)assoc.getModel()));
        }
        return assocs;
    }

    private TopicViewModel createTopicViewModel(RelatedTopic topic) {
        try {
            ViewProperties viewProps = this.fetchViewProperties(topic.getRelatingAssociation());
            this.invokeViewmodelCustomizers(topic, viewProps);
            return this.mf.newTopicViewModel((TopicModel)topic.getModel(), viewProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Creating viewmodel for topic " + topic.getId() + " failed", e);
        }
    }

    private Association fetchTopicRefAssociation(long topicmapId, long topicId) {
        return this.dm4.getAssociation(TOPIC_MAPCONTEXT, topicmapId, topicId, ROLE_TYPE_TOPICMAP, ROLE_TYPE_TOPIC);
    }

    private Association fetchAssociationRefAssociation(long topicmapId, long assocId) {
        return this.dm4.getAssociationBetweenTopicAndAssociation(ASSOCIATION_MAPCONTEXT, topicmapId, assocId, ROLE_TYPE_TOPICMAP, ROLE_TYPE_ASSOCIATION);
    }

    private ViewProperties fetchViewProperties(Association mapcontextAssoc) {
        int x = (Integer)mapcontextAssoc.getProperty(PROP_X);
        int y = (Integer)mapcontextAssoc.getProperty(PROP_Y);
        boolean visibility = (Boolean)mapcontextAssoc.getProperty(PROP_VISIBILITY);
        return new ViewProperties(x, y, visibility);
    }

    private void storeViewProperties(long topicmapId, long topicId, ViewProperties viewProps) {
        try {
            Association assoc = this.fetchTopicRefAssociation(topicmapId, topicId);
            if (assoc == null) {
                throw new RuntimeException("Topic " + topicId + " is not contained in topicmap " + topicmapId);
            }
            this.storeViewProperties(assoc, viewProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Storing view properties of topic " + topicId + " failed (viewProps=" + viewProps + ")", e);
        }
    }

    private void storeViewProperties(Association mapcontextAssoc, ViewProperties viewProps) {
        for (String propUri : viewProps) {
            mapcontextAssoc.setProperty(propUri, viewProps.get(propUri), false);
        }
    }

    private void invokeViewmodelCustomizers(RelatedTopic topic, ViewProperties viewProps) {
        for (ViewmodelCustomizer customizer : this.viewmodelCustomizers) {
            this.invokeViewmodelCustomizer(customizer, topic, viewProps);
        }
    }

    private void invokeViewmodelCustomizer(ViewmodelCustomizer customizer, RelatedTopic topic, ViewProperties viewProps) {
        try {
            customizer.enrichViewProperties(topic, viewProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Invoking viewmodel customizer for topic " + topic.getId() + " failed (customizer=\"" + customizer.getClass().getName() + "\")", e);
        }
    }

    private TopicmapRenderer getTopicmapRenderer(String rendererUri) {
        TopicmapRenderer renderer = this.topicmapRenderers.get(rendererUri);
        if (renderer == null) {
            throw new RuntimeException("\"" + rendererUri + "\" is an unknown topicmap renderer");
        }
        return renderer;
    }

    private InputStream invokeWebclient() {
        return this.dm4.getPlugin("de.deepamehta.webclient").getStaticResource("/web/index.html");
    }
}

