/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.util;

import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.Identifiable;
import de.deepamehta.core.JSONEnabled;
import de.deepamehta.core.Topic;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.DeepaMehtaObjectModel;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.TopicRoleModel;
import de.deepamehta.core.service.CoreService;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class DeepaMehtaUtils {
    private static final Logger logger = Logger.getLogger(DeepaMehtaUtils.class.getName());
    private static final String DM4_HOST_URL = System.getProperty("dm4.host.url");

    public static boolean isDeepaMehtaURL(URL url) {
        try {
            return url.toString().startsWith(DM4_HOST_URL);
        }
        catch (Exception e) {
            throw new RuntimeException("Checking for DeepaMehta URL failed (url=\"" + url + "\")", e);
        }
    }

    public static List<Long> idList(Iterable<? extends Identifiable> items) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Identifiable identifiable : items) {
            ids.add(identifiable.getId());
        }
        return ids;
    }

    public static <M> List<M> toModelList(Iterable<? extends DeepaMehtaObject> objects) {
        ArrayList<DeepaMehtaObjectModel> modelList = new ArrayList<DeepaMehtaObjectModel>();
        for (DeepaMehtaObject deepaMehtaObject : objects) {
            modelList.add(deepaMehtaObject.getModel());
        }
        return modelList;
    }

    public static String topicNames(Iterable<? extends Topic> topics) {
        StringBuilder names = new StringBuilder();
        Iterator<? extends Topic> i = topics.iterator();
        while (i.hasNext()) {
            Topic topic = i.next();
            names.append('\"').append(topic.getSimpleValue()).append('\"');
            if (!i.hasNext()) continue;
            names.append(", ");
        }
        return names.toString();
    }

    public static <T extends DeepaMehtaObject> List<T> loadChildTopics(List<T> objects) {
        for (DeepaMehtaObject object : objects) {
            object.loadChildTopics();
        }
        return objects;
    }

    public static Map toMap(JSONObject o) {
        return DeepaMehtaUtils.toMap(o, new HashMap());
    }

    public static Map toMap(JSONObject o, Map map) {
        try {
            Iterator i = o.keys();
            while (i.hasNext()) {
                String key = (String)i.next();
                map.put(key, o.get(key));
            }
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException("Converting JSONObject to Map failed", e);
        }
    }

    public static List toList(JSONArray o) {
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < o.length(); ++i) {
                list.add(o.get(i));
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException("Converting JSONArray to List failed", e);
        }
    }

    public static JSONArray toJSONArray(Iterable<? extends JSONEnabled> items) {
        JSONArray array = new JSONArray();
        for (JSONEnabled jSONEnabled : items) {
            array.put((Object)jSONEnabled.toJSON());
        }
        return array;
    }

    public static RoleModel[] associationAutoTyping(AssociationModel assoc, String topicTypeUri1, String topicTypeUri2, String assocTypeUri, String roleTypeUri1, String roleTypeUri2, CoreService dm4) {
        if (!assoc.getTypeUri().equals("dm4.core.association")) {
            return null;
        }
        RoleModel[] roles = DeepaMehtaUtils.getRoleModels(assoc, topicTypeUri1, topicTypeUri2, dm4);
        if (roles != null) {
            logger.info("### Auto typing association into \"" + assocTypeUri + "\" (\"" + topicTypeUri1 + "\" <-> \"" + topicTypeUri2 + "\")");
            assoc.setTypeUri(assocTypeUri);
            roles[0].setRoleTypeUri(roleTypeUri1);
            roles[1].setRoleTypeUri(roleTypeUri2);
        }
        return roles;
    }

    public static RoleModel[] getRoleModels(AssociationModel assoc, String topicTypeUri1, String topicTypeUri2, CoreService dm4) {
        RoleModel r1 = assoc.getRoleModel1();
        RoleModel r2 = assoc.getRoleModel2();
        if (!(r1 instanceof TopicRoleModel) || ((TopicRoleModel)r1).topicIdentifiedByUri() || !(r2 instanceof TopicRoleModel) || ((TopicRoleModel)r2).topicIdentifiedByUri()) {
            return null;
        }
        String t1 = (String)dm4.getProperty(r1.getPlayerId(), "type_uri");
        String t2 = (String)dm4.getProperty(r2.getPlayerId(), "type_uri");
        RoleModel roleModel1 = DeepaMehtaUtils.getRoleModel(r1, r2, t1, t2, topicTypeUri1, 1);
        RoleModel roleModel2 = DeepaMehtaUtils.getRoleModel(r1, r2, t1, t2, topicTypeUri2, 2);
        if (roleModel1 != null && roleModel2 != null) {
            return new RoleModel[]{roleModel1, roleModel2};
        }
        return null;
    }

    private static RoleModel getRoleModel(RoleModel r1, RoleModel r2, String t1, String t2, String topicTypeUri, int nr) {
        boolean m1 = t1.equals(topicTypeUri);
        boolean m2 = t2.equals(topicTypeUri);
        if (m1 && m2) {
            return nr == 1 ? r1 : r2;
        }
        return m1 ? r1 : (m2 ? r2 : null);
    }

    static {
        logger.info("Host setting:\ndm4.host.url=\"" + DM4_HOST_URL + "\"");
    }
}

