/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.impl.AssociationModelImpl;
import de.deepamehta.core.impl.ChildTopicsModelImpl;
import de.deepamehta.core.impl.DeepaMehtaObjectModelImpl;
import de.deepamehta.core.impl.PersistenceLayer;
import de.deepamehta.core.impl.RelatedTopicModelImpl;
import de.deepamehta.core.impl.TopicModelImpl;
import de.deepamehta.core.model.AssociationDefinitionModel;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.DeepaMehtaObjectModel;
import de.deepamehta.core.model.RelatedTopicModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicReferenceModel;
import java.util.List;
import java.util.logging.Logger;

class ValueStorage {
    private PersistenceLayer pl;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    ValueStorage(PersistenceLayer pl) {
        this.pl = pl;
    }

    void fetchChildTopics(DeepaMehtaObjectModel parent) {
        for (AssociationDefinitionModel associationDefinitionModel : ((DeepaMehtaObjectModelImpl)parent).getType().getAssocDefs()) {
            this.fetchChildTopics(parent, associationDefinitionModel);
        }
    }

    void fetchChildTopics(DeepaMehtaObjectModel parent, AssociationDefinitionModel assocDef) {
        block6: {
            try {
                ChildTopicsModel childTopics = parent.getChildTopicsModel();
                String cardinalityUri = assocDef.getChildCardinalityUri();
                String assocDefUri = assocDef.getAssocDefUri();
                if (cardinalityUri.equals("dm4.core.one")) {
                    RelatedTopicModel childTopic = this.fetchChildTopic(parent.getId(), assocDef);
                    if (childTopic != null) {
                        childTopics.put(assocDefUri, childTopic);
                        this.fetchChildTopics(childTopic);
                    }
                    break block6;
                }
                if (cardinalityUri.equals("dm4.core.many")) {
                    for (RelatedTopicModel relatedTopicModel : this.fetchChildTopics(parent.getId(), assocDef)) {
                        childTopics.add(assocDefUri, relatedTopicModel);
                        this.fetchChildTopics(relatedTopicModel);
                    }
                    break block6;
                }
                throw new RuntimeException("\"" + cardinalityUri + "\" is an unexpected cardinality URI");
            }
            catch (Exception e) {
                throw new RuntimeException("Fetching the \"" + assocDef.getAssocDefUri() + "\" child topics of object " + parent.getId() + " failed", e);
            }
        }
    }

    void storeValue(DeepaMehtaObjectModelImpl model) {
        if (model.getType().getDataTypeUri().equals("dm4.core.composite")) {
            this.storeChildTopics(model);
            model.calculateLabelAndUpdate();
        } else {
            model.storeSimpleValue();
        }
    }

    private void storeChildTopics(DeepaMehtaObjectModelImpl parent) {
        ChildTopicsModelImpl model = null;
        try {
            model = parent.getChildTopicsModel();
            for (AssociationDefinitionModel associationDefinitionModel : parent.getType().getAssocDefs()) {
                String assocDefUri = associationDefinitionModel.getAssocDefUri();
                String cardinalityUri = associationDefinitionModel.getChildCardinalityUri();
                if (cardinalityUri.equals("dm4.core.one")) {
                    RelatedTopicModelImpl childTopic = model.getTopicOrNull(assocDefUri);
                    if (childTopic == null) continue;
                    this.storeChildTopic(childTopic, parent, associationDefinitionModel);
                    continue;
                }
                if (cardinalityUri.equals("dm4.core.many")) {
                    List<RelatedTopicModelImpl> childTopics = model.getTopicsOrNull(assocDefUri);
                    if (childTopics == null) continue;
                    for (RelatedTopicModelImpl childTopic : childTopics) {
                        this.storeChildTopic(childTopic, parent, associationDefinitionModel);
                    }
                    continue;
                }
                throw new RuntimeException("\"" + cardinalityUri + "\" is an unexpected cardinality URI");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Storing the child topics of object " + parent.getId() + " failed (" + model + ")", e);
        }
    }

    private void storeChildTopic(RelatedTopicModelImpl childTopic, DeepaMehtaObjectModel parent, AssociationDefinitionModel assocDef) {
        if (childTopic instanceof TopicReferenceModel) {
            this.resolveReference((TopicReferenceModel)((Object)childTopic));
        } else {
            this.pl.createTopic(childTopic);
        }
        this.associateChildTopic(parent, childTopic, assocDef);
    }

    void resolveReference(TopicReferenceModel topicRef) {
        topicRef.set(this.fetchReferencedTopic(topicRef));
    }

    private DeepaMehtaObjectModel fetchReferencedTopic(TopicReferenceModel topicRef) {
        if (topicRef.isReferenceById()) {
            return this.pl.fetchTopic(topicRef.getId()).loadChildTopics();
        }
        if (topicRef.isReferenceByUri()) {
            TopicModelImpl topic = this.pl.fetchTopic("uri", new SimpleValue(topicRef.getUri()));
            if (topic == null) {
                throw new RuntimeException("Topic with URI \"" + topicRef.getUri() + "\" not found");
            }
            return topic.loadChildTopics();
        }
        throw new RuntimeException("Invalid topic reference (" + topicRef + ")");
    }

    void associateChildTopic(DeepaMehtaObjectModel parent, RelatedTopicModel childTopic, AssociationDefinitionModel assocDef) {
        AssociationModel assoc = childTopic.getRelatingAssociation();
        assoc.setTypeUri(assocDef.getInstanceLevelAssocTypeUri());
        assoc.setRoleModel1(parent.createRoleModel("dm4.core.parent"));
        assoc.setRoleModel2(childTopic.createRoleModel("dm4.core.child"));
        this.pl.createAssociation((AssociationModelImpl)assoc);
    }

    private RelatedTopicModel fetchChildTopic(long parentId, AssociationDefinitionModel assocDef) {
        return this.pl.fetchRelatedTopic(parentId, assocDef.getInstanceLevelAssocTypeUri(), "dm4.core.parent", "dm4.core.child", assocDef.getChildTypeUri());
    }

    private List<RelatedTopicModelImpl> fetchChildTopics(long parentId, AssociationDefinitionModel assocDef) {
        return this.pl.fetchRelatedTopics(parentId, assocDef.getInstanceLevelAssocTypeUri(), "dm4.core.parent", "dm4.core.child", assocDef.getChildTypeUri());
    }
}

