/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.impl.AssociationModelImpl;
import de.deepamehta.core.impl.CoreEvent;
import de.deepamehta.core.impl.DeepaMehtaObjectModelImpl;
import de.deepamehta.core.impl.RelatedTopicModelImpl;
import de.deepamehta.core.impl.TopicImpl;
import de.deepamehta.core.impl.TopicTypeModelImpl;
import de.deepamehta.core.model.AssociationDefinitionModel;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.IndexMode;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.service.DeepaMehtaEvent;
import de.deepamehta.core.service.Directive;
import java.util.List;

class TopicModelImpl
extends DeepaMehtaObjectModelImpl
implements TopicModel {
    TopicModelImpl(DeepaMehtaObjectModelImpl object) {
        super(object);
    }

    @Override
    public RoleModel createRoleModel(String roleTypeUri) {
        return this.mf.newTopicRoleModel(this.id, roleTypeUri);
    }

    @Override
    public TopicModel clone() {
        try {
            return (TopicModel)super.clone();
        }
        catch (Exception e) {
            throw new RuntimeException("Cloning a TopicModel failed", e);
        }
    }

    @Override
    public String toString() {
        return "topic (" + super.toString() + ")";
    }

    @Override
    String className() {
        return "topic";
    }

    @Override
    TopicImpl instantiate() {
        return new TopicImpl(this, this.pl);
    }

    @Override
    final TopicModelImpl createModelWithChildTopics(ChildTopicsModel childTopics) {
        return this.mf.newTopicModel(childTopics);
    }

    @Override
    final TopicTypeModelImpl getType() {
        return this.pl.typeStorage.getTopicType(this.typeUri);
    }

    @Override
    final List<AssociationModelImpl> getAssociations() {
        return this.pl.fetchTopicAssociations(this.id);
    }

    @Override
    final RelatedTopicModelImpl getRelatedTopic(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.pl.fetchTopicRelatedTopic(this.id, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    @Override
    final List<RelatedTopicModelImpl> getRelatedTopics(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.pl.fetchTopicRelatedTopics(this.id, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    @Override
    final List<RelatedTopicModelImpl> getRelatedTopics(List assocTypeUris, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.pl.fetchTopicRelatedTopics(this.id, assocTypeUris, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    @Override
    final void storeUri() {
        this.pl.storeTopicUri(this.id, this.uri);
    }

    @Override
    final void storeTypeUri() {
        this.reassignInstantiation();
        this.pl.storeTopicTypeUri(this.id, this.typeUri);
    }

    @Override
    final void storeSimpleValue() {
        TopicTypeModelImpl type = this.getType();
        this.pl.storeTopicValue(this.id, this.value, type.getIndexModes(), type.getUri(), this.getIndexValue());
    }

    @Override
    final void indexSimpleValue(IndexMode indexMode) {
        this.pl.indexTopicValue(this.id, indexMode, this.typeUri, this.getIndexValue());
    }

    @Override
    final void storeProperty(String propUri, Object propValue, boolean addToIndex) {
        this.pl.storeTopicProperty(this.id, propUri, propValue, addToIndex);
    }

    @Override
    final void removeProperty(String propUri) {
        this.pl.removeTopicProperty(this.id, propUri);
    }

    @Override
    final void _delete() {
        this.pl._deleteTopic(this.id);
    }

    @Override
    final void checkReadAccess() {
        this.pl.checkTopicReadAccess(this.id);
    }

    @Override
    final void checkWriteAccess() {
        this.pl.checkTopicWriteAccess(this.id);
    }

    @Override
    final DeepaMehtaEvent getPreUpdateEvent() {
        return CoreEvent.PRE_UPDATE_TOPIC;
    }

    @Override
    final DeepaMehtaEvent getPostUpdateEvent() {
        return CoreEvent.POST_UPDATE_TOPIC;
    }

    @Override
    final DeepaMehtaEvent getPreDeleteEvent() {
        return CoreEvent.PRE_DELETE_TOPIC;
    }

    @Override
    final DeepaMehtaEvent getPostDeleteEvent() {
        return CoreEvent.POST_DELETE_TOPIC;
    }

    @Override
    final Directive getUpdateDirective() {
        return Directive.UPDATE_TOPIC;
    }

    @Override
    final Directive getDeleteDirective() {
        return Directive.DELETE_TOPIC;
    }

    @Override
    void preDelete() {
        if (this.typeUri.equals("dm4.core.topic_type") || this.typeUri.equals("dm4.core.assoc_type")) {
            throw new RuntimeException("Tried to delete a type with a generic delete-topic call. Use a delete-type call instead.");
        }
    }

    TopicModelImpl findChildTopic(String topicTypeUri) {
        try {
            if (this.typeUri.equals(topicTypeUri)) {
                return this;
            }
            for (AssociationDefinitionModel associationDefinitionModel : this.getType().getAssocDefs()) {
                String assocDefUri = associationDefinitionModel.getAssocDefUri();
                String cardinalityUri = associationDefinitionModel.getChildCardinalityUri();
                TopicModelImpl childTopic = null;
                if (cardinalityUri.equals("dm4.core.one")) {
                    childTopic = this.childTopics.getTopicOrNull(assocDefUri);
                } else if (cardinalityUri.equals("dm4.core.many")) {
                    List<RelatedTopicModelImpl> _childTopics = this.childTopics.getTopicsOrNull(assocDefUri);
                    if (_childTopics != null && !_childTopics.isEmpty()) {
                        childTopic = _childTopics.get(0);
                    }
                } else {
                    throw new RuntimeException("\"" + cardinalityUri + "\" is an unexpected cardinality URI");
                }
                if (childTopic == null || (childTopic = childTopic.findChildTopic(topicTypeUri)) == null) continue;
                return childTopic;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Searching topic " + this.id + " for \"" + topicTypeUri + "\" failed", e);
        }
    }

    private void reassignInstantiation() {
        this.fetchInstantiation().delete();
        this.pl.createTopicInstantiation(this.id, this.typeUri);
    }

    private AssociationModelImpl fetchInstantiation() {
        RelatedTopicModelImpl topicType = this.getRelatedTopic("dm4.core.instantiation", "dm4.core.instance", "dm4.core.type", "dm4.core.topic_type");
        if (topicType == null) {
            throw new RuntimeException("Topic " + this.id + " is not associated to a topic type");
        }
        return topicType.getRelatingAssociation();
    }
}

