/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.AssociationDefinition;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.DeepaMehtaType;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.impl.ChildTopicsImpl;
import de.deepamehta.core.impl.ChildTopicsModelImpl;
import de.deepamehta.core.impl.DeepaMehtaObjectModelImpl;
import de.deepamehta.core.impl.ModelFactoryImpl;
import de.deepamehta.core.impl.PersistenceLayer;
import de.deepamehta.core.impl.RelatedTopicModelImpl;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.RelatedTopicModel;
import de.deepamehta.core.model.SimpleValue;
import java.util.List;
import org.codehaus.jettison.json.JSONObject;

abstract class DeepaMehtaObjectImpl
implements DeepaMehtaObject {
    DeepaMehtaObjectModelImpl model;
    PersistenceLayer pl;
    ModelFactoryImpl mf;

    DeepaMehtaObjectImpl(DeepaMehtaObjectModelImpl model, PersistenceLayer pl) {
        this.model = model;
        this.pl = pl;
        this.mf = pl.mf;
    }

    @Override
    public final long getId() {
        return this.model.getId();
    }

    @Override
    public final String getUri() {
        return this.model.getUri();
    }

    @Override
    public final void setUri(String uri) {
        this.model.updateUri(uri);
    }

    @Override
    public final String getTypeUri() {
        return this.model.getTypeUri();
    }

    @Override
    public final void setTypeUri(String typeUri) {
        this.model.updateTypeUri(typeUri);
    }

    @Override
    public final SimpleValue getSimpleValue() {
        return this.model.getSimpleValue();
    }

    @Override
    public final void setSimpleValue(String value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public final void setSimpleValue(int value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public final void setSimpleValue(long value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public final void setSimpleValue(boolean value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public final void setSimpleValue(SimpleValue value) {
        this.model.updateSimpleValue(value);
    }

    @Override
    public final ChildTopicsImpl getChildTopics() {
        return new ChildTopicsImpl(this.model.childTopics, this.model, this.pl);
    }

    @Override
    public final void setChildTopics(ChildTopicsModel childTopics) {
        try {
            this.model._updateChildTopics((ChildTopicsModelImpl)childTopics);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting the child topics failed (" + childTopics + ")", e);
        }
    }

    @Override
    public DeepaMehtaObject loadChildTopics() {
        this.model.loadChildTopics();
        return this;
    }

    @Override
    public DeepaMehtaObject loadChildTopics(String assocDefUri) {
        this.model.loadChildTopics(assocDefUri);
        return this;
    }

    @Override
    public final DeepaMehtaType getType() {
        return this.model.getType().instantiate();
    }

    @Override
    public DeepaMehtaObjectModelImpl getModel() {
        return this.model;
    }

    @Override
    public final void updateChildTopic(RelatedTopicModel newChildTopic, AssociationDefinition assocDef) {
        this.model.updateChildTopics((RelatedTopicModelImpl)newChildTopic, null, assocDef.getModel());
    }

    @Override
    public final void updateChildTopics(List<? extends RelatedTopicModel> newChildTopics, AssociationDefinition assocDef) {
        this.model.updateChildTopics(null, newChildTopics, assocDef.getModel());
    }

    @Override
    public final RelatedTopic getRelatedTopic(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        RelatedTopicModelImpl topic = this.model.getRelatedTopic(assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        return topic != null ? (RelatedTopic)this.pl.checkReadAccessAndInstantiate(topic) : null;
    }

    @Override
    public final List<RelatedTopic> getRelatedTopics(String assocTypeUri) {
        return this.getRelatedTopics(assocTypeUri, null, null, null);
    }

    @Override
    public final List<RelatedTopic> getRelatedTopics(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        List<RelatedTopicModelImpl> topics = this.model.getRelatedTopics(assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        return this.pl.checkReadAccessAndInstantiate(topics);
    }

    @Override
    public final Object getProperty(String propUri) {
        return this.pl.fetchProperty(this.getId(), propUri);
    }

    @Override
    public final boolean hasProperty(String propUri) {
        return this.pl.hasProperty(this.getId(), propUri);
    }

    @Override
    public final void setProperty(String propUri, Object propValue, boolean addToIndex) {
        this.model.storeProperty(propUri, propValue, addToIndex);
    }

    @Override
    public final void removeProperty(String propUri) {
        this.model.removeProperty(propUri);
    }

    @Override
    public final Object getDatabaseVendorObject() {
        return this.pl.getDatabaseVendorObject(this.getId());
    }

    @Override
    public final JSONObject toJSON() {
        return this.model.toJSON();
    }

    public final boolean equals(Object o) {
        return ((DeepaMehtaObjectImpl)o).model.equals(this.model);
    }

    public final int hashCode() {
        return this.model.hashCode();
    }

    public final String toString() {
        return this.model.toString();
    }

    final String className() {
        return this.model.className();
    }
}

