/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.tasks;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.felix.eventadmin.impl.tasks.SyncThread;
import org.apache.felix.eventadmin.impl.util.LogWrapper;

public class DefaultThreadPool {
    private ExecutorService executor;
    private final ThreadFactory threadFactory;
    private int oldSize = -1;

    public DefaultThreadPool(int poolSize, boolean syncThreads) {
        this.threadFactory = syncThreads ? new ThreadFactory(){

            @Override
            public Thread newThread(Runnable command) {
                SyncThread thread = new SyncThread(command);
                thread.setPriority(5);
                thread.setDaemon(true);
                return thread;
            }
        } : new ThreadFactory(){

            @Override
            public Thread newThread(Runnable command) {
                Thread thread = new Thread(command);
                thread.setPriority(5);
                thread.setDaemon(true);
                return thread;
            }
        };
        this.configure(poolSize);
    }

    public synchronized void configure(int poolSize) {
        if (this.oldSize != poolSize) {
            this.oldSize = poolSize;
            ExecutorService oldService = this.executor;
            this.executor = Executors.newFixedThreadPool(poolSize, this.threadFactory);
            if (oldService != null) {
                oldService.shutdown();
            }
        }
    }

    public void close() {
        this.executor.shutdownNow();
    }

    public void executeTask(Runnable task) {
        try {
            this.executor.submit(task);
        }
        catch (Throwable t) {
            LogWrapper.getLogger().log(2, "Exception: " + t, t);
        }
    }
}

